$(function ($) {
    $.validator.setDefaults({
        // Bug fix to jquery.validation to not show validation errors on initial field fill
        onkeyup: function (element, event) {
            if (event.which === 9 && this.elementValue(element) === '') {
                return;
            } else if (element.name in this.submitted /* || element === this.lastActive */) {
                this.element(element);
            }
        },
        // Updated highlight for Bootstrap 3
        highlight: function (element, errorClass, validClass) {
            if (element == null) {
                /* If error below, have bound a ModelState error for a non-existent field */
                console.log('Attempt to highlight non-existent element');
                return;
            }

            if (element.type === 'radio') {
                this.findByName(element.name).addClass(errorClass).removeClass(validClass);
            } else {
                $(element).addClass(errorClass).removeClass(validClass);
                // Don't show success 
                // $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
                $(element).closest('.form-group').addClass('has-error');
            }
        },
        // Updated unhighlight for Bootstrap 3
        unhighlight: function (element, errorClass, validClass) {
            if (element == null) {
                /* If error below, have bound a ModelState error for a non-existent field */
                console.log('Attempt to highlight non-existent element');
                return;
            }

            if (element.type === 'radio') {
                this.findByName(element.name).removeClass(errorClass).addClass(validClass);
            } else {
                $(element).removeClass(errorClass).addClass(validClass);
                // Don't show success
                //$(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                $(element).closest('.form-group').removeClass('has-error');
            }
            
        }
    });

    // Bug fix for jquery.Validation to allow en-AU date validation
    // Integrated with Bootstrap datepicker's parseDate but could be replaced with others
    // See: http://forums.asp.net/post/5102828.aspx
    // See: http://stackoverflow.com/a/10344219/364
    $.validator.methods.date = function(value, element) {
        if (this.optional(element)) {
            return true;
        };
        
        try {
            $.fn.datepicker.DPGlobal.parseDate(value, 'dd/mm/yyyy', 'en');
            return true;
        } catch (err) {
            alert(err);
            return false;
        }
    };
    
    // Add "mandatory" as a validation rule type for required checkboxes.
    $.validator.unobtrusive.adapters.addBool("mandatory", "required");
}(jQuery));
